<?php
/**
 *
 * @package 
 * @author     Ole Jungclaussen
 * @version    0.9.1
 * @.copyright 2021-23, Ole Jungclaussen
 */

class CSteamServerProps {
    /**
     * 
     * @var null|string
     */
    public ?string $addr = null;

    /**
     * 
     * @var null|string
     */
    public ?string $gameport = null;

    /**
     * 
     * @var null|string
     */
    public ?string $steamid = null;

    /**
     * 
     * @var null|string
     */
    public ?string $name = null;

    /**
     * 
     * @var null|int
     */
    public ?int $appid = null;

    /**
     * 
     * @var null|string
     */
    public ?string $gamedir = null;

    /**
     * 
     * @var null|string
     */
    public ?string $version = null;

    /**
     * 
     * @var null|string
     */
    public ?string $product = null;

    /**
     * 
     * @var null|int
     */
    public ?int $region = null;

    /**
     * 
     * @var null|int
     */
    public ?int $players = null;

    /**
     * 
     * @var null|int
     */
    public ?int $max_players = null;

    /**
     * 
     * @var null|int
     */
    public ?int $bots = null;
    /**
     * 
     * @var null|string
     */
    public ?string $map = null;

    /**
     * 
     * @var null|bool
     */
    public ?bool $secure = null;

    /**
     * 
     * @var null|bool
     */
    public ?bool $dedicated = null;
    /**
     * 
     * @var null|string
     */
    public ?string $os = null;
    /**
     * 
     * @var null|string
     */
    public ?string $gametype = null;

    /**
     * 
     * @param mixed $ObjFromSteam 
     * @return void 
     */
    function __construct($ObjFromSteam)
    {
        foreach ($this as $key => $ignore)
        {
            if(property_exists($ObjFromSteam, $key))
            {
                $this->$key = $ObjFromSteam->$key;
            }
        }
    }
}
/**
 * A server's Info retrieved from STEAM
 * @package 
 */
class CServerBySteam {

    /**
     * 
     * @var string
     */
    public ?string $sIp   = null;

    /**
     * 
     * @var string
     */
    public ?string $sPort = null;

    /**
     * 
     * @var null|CSteamServerProps
     */
    public ?CSteamServerProps $SteamServerProps = null;
    /**
     * 
     * @param string $sIp 
     * @param string $sPort 
     * @return void 
     */
    function __construct(object $ObjFromSteam)
    {
        $this->SteamServerProps = new CSteamServerProps($ObjFromSteam);

        $this->sIp   = preg_replace('/:'.$this->SteamServerProps->gameport.'$/', '', $this->SteamServerProps->addr);
        $this->sPort = $this->SteamServerProps->gameport;

    }
}
/**
 * Server List from STEAM
 * @package 
 */
class CServerlistBySteam {
// ########## PROPS PUBLIC
    /**
     * Servers running the game
     * 
     * @var CServerBySteam[]
     */
    public array $aServers = [];
    /**
     * Number of servers running the game
     * @var int
     */
    public int $nServers = 0;
// ########## PROPS PROTECTED
    /**
     * 
     * @var null|array
     */
    protected ?array $fnLog = null;
    /**
     * 
     * @var boolean
     */
    protected bool $bLogDiagnostics = false;
// ########## PROPS PRIVATE
// ########## CONST/DEST
    function __construct()
    {
        
    }
    function __destruct()
    {
        
    }
// ########## METHOD PUBLIC
    /**
     * 
     * @param array $fnLog call_user_func($fnLog, "text to log") 
     * @return void 
     */
    public function setDiagnosticLog(array $fnLog)
    {
        $this->fnLog = $fnLog;
        $this->bLogDiagnostics = true;
    }

    /**
     * Query List of Servers.
     * 
     * @return void 
     * @throws Exception 
     */
    public function load(string $sApiKey, string $sAppId) : void
    {
        $aServerList = $this->retrieveList($sApiKey, $sAppId);

        foreach($aServerList as $Srv)
        {
            $this->aServers[] = new CServerBySteam($Srv);
            $this->nServers++;

            // print '<pre>'; var_dump($Srv); print '</pre>';
            // print '<pre>'; var_dump($this->aServers[$this->nServers-1]); print '</pre>';
            // print '<hr>';
        }

        if($this->bLogDiagnostics)
        {
            call_user_func($this->fnLog, 'master server request done' );
        }
    }
    
    /**
     * 
     * @return int 
     */
    public function countServers() : int
    {
        return($this->nServers);
    }
    
    /**
     * 
     * @return void 
     */
    public function destroy() : void
    {
    }
// ########## METHOD PROTECTED
    /**
     * 
     * @param string $sApiKey 
     * @param string $sAppId 
     * @return array 
     */
    protected function retrieveList(string $sApiKey, string $sAppId) : array
    {
        $aServerList = [];
        $sUrl = 'https://api.steampowered.com/IGameServersService/GetServerList/v1/?key='.$sApiKey.'&filter=\\appid\\'.$sAppId;
        $Con  = false;
        $sJson = '';
        $Data = null;

        $this->aServers = array();
        $this->nServers = 0;
     
     
        if(false===($Con = curl_init($sUrl)))
        {
            if($this->bLogDiagnostics) call_user_func($this->fnLog, 'failed to init curl' );
            return $aServerList;
        }
        
        curl_setopt($Con, CURLOPT_RETURNTRANSFER, true);
    	curl_setopt($Con, CURLOPT_SSL_VERIFYPEER, false);
        curl_setopt($Con, CURLOPT_HTTPHEADER, [ 'Accept: application/json']);

        $sJson = curl_exec($Con);

        if (curl_errno($Con)) 
        {
            curl_close($Con);
            if($this->bLogDiagnostics) call_user_func($this->fnLog, 'curl_exec failed on '.curl_errno($Con) );
            return $aServerList;
        }
        
        curl_close($Con);

        $Data = json_decode($sJson);

        if(is_object($Data) && property_exists($Data, 'response') && property_exists($Data->response, 'servers'))
        {
            $aServerList = $Data->response->servers;
        }
        else
        {
            if($this->bLogDiagnostics) call_user_func($this->fnLog, $sJson );
        }

        return $aServerList;
    }
// ########## METHOD PRIVATE
};
